
#ifndef _BLEPROCESS_H_
#define _BLEPROCESS_H_

#include	"ht8.h"
#include	"bc7701.h"
/*------ Change UART Baud Rate Enable/Disable --------------------*/
#define	_CHG_BAUD_RATE_ENABLE_		1
//#define 	_CHANGE_BAUDRATE_				BAUD_RATE_19200
//#define 	_CHANGE_BAUDRATE_				BAUD_RATE_25000
//#define 	_CHANGE_BAUDRATE_				BAUD_RATE_50000
#define 	_CHANGE_BAUDRATE_				BAUD_RATE_115200
/*------ Change Crystal C-Load Enable/Disable --------------------*/
#define	_CLOAD_CFG_ENABLE_   		1
#define 	_CLOAD_VALUE_  				04
/*------ Change TX Power Enable/Disable --------------------------*/
#define	_TXPWR_CFG_ENABLE_   		1
#define 	_TX_POWER_VALUE_  			10
/*------ Configure BT Device Name Enable/Disable ----------------*/
#define	_BDNAME_CFG_ENABLE_   		1
/*------ Configure Advertising data Enable/Disable --------------*/
#define	_ADV_DATA_CFG_ENABLE_   	1
/*------ Configure Scan Response Data Enable/Disable ------------*/
#define	_SCAN_DATA_CFG_ENABLE_   	0
/*------ Configure Advertising interval Enable/Disable -----------*/
#define	_ADV_INTV_CFG_ENABLE_   	1
/*------ Min Interval(ms)<10-40000> ------------------------------*/
#define 	_ADV_INTV_MIN_VALUE_  		(1000)
/*------ Max Interval(ms)<10-40000> ------------------------------*/
#define 	_ADV_INTV_MAX_VALUE_  		(1000)
/*------ Configure Feature setup ---------------------------------*/
//#define	FEATURE_STATUS_SETUP		(FEATURE_STATUS_EVENT+FEATURE_EXTERNAL32K)		/* external 32.768K */
#define	FEATURE_STATUS_SETUP		(FEATURE_STATUS_EVENT)
/*------ Power On finish BC7701 to Sleep mode Enable/Disable -----*/
#define	_PWRON_FINISH_SLEEP_			0


/* define timer,unit 2ms */
#define	RESET_DELAY_TIME			6/2		/* reset pin low time */
#define	PWRUP_DELAY_TIME			46/2		/* BC7701 hardware reset delay time */
#define  EVENT_RETURN_TIME    	500/2		/* 500ms */
#define	CHG_BAUD_DELAY_TIME		2/2
#define	RF_CALIBRAT_TIME			600/2		/* 420ms */
#define	DTM_CALIBRAT_TIME			800/2		/* 800ms */

#define	EVENT_RSP_EMPTY			0x0E0E   /* no event response */
#define	EVENT_RSP_TIMEOUT			0x0E

#if (_CHG_BAUD_RATE_ENABLE_ == 1)
#if (_CHANGE_BAUDRATE_ < BAUD_RATE_115200)
#define	DUMMY_WAKEUP_WIDTH		1
#else
#define	DUMMY_WAKEUP_WIDTH		2
#endif
#endif
/*---------- BC7701 power on step define --------------*/
enum
{
   _BLE_START_ 				= 0x00,	
   _BLE_POWER_UP_ 			= 0x10,
   _BLE_RESET_DELAY_,
   _BLE_PWRUP_DELAY_,
	_BLE_PWRUP_EXAMINE_,
	_BLE_RECORD_DATECODE_,
	_BLE_RECORD_BDADDR_,
	_BLE_CHG_BAUD_RATE_		= 0x20,
	_BLE_CHG_UART_BAUD_,
	_BLE_PARAMETER_MODIFY,
	_BLE_FEATURE_SETUP_,	
	_BLE_ADV_ENABLE_			= 0x80,
	_BLE_ADV_DELAY_S_,	
	_BLE_ADV_DELAY_E_,		
	_BLE_SAVE_SW_PARA_		= 0x90,	
	_BLE_DEEP_SLEEP_,	
	_BLE_EVENT_RESPONSE_ 	= 0xAC,
	_BLE_PWR_ON_FINISH_ 		= 0xE0,
	_BLE_PWR_ON_SUCCESS_		= 0xEA,
	_BLE_ENTER_PWR_SAVE_		= 0xFA,
	_BLE_POWER_SAVE_			= 0xFB,
	_BLE_POWER_DOWN_ 			= 0xFD,
   _BLE_PWR_ON_ERROR_ 		= 0xFF	
};

typedef struct 
{	
	u8		DateCode[6];
	tDEV_ADDR	BDAddr;
	union
	{
		struct
		{
			u8	EventValid : 1;
			u8	TmCntFinish : 1;						/* timer counter finish */
			u8	EventFinish : 1;						/* event parser finish flag */
			u8	HostConnect : 1;						/* BC7601 and HOST are connected flag */ 
			u8	TmDelay : 1;
		}B;
		u8	V;
	}F;	
	u8		State;										/* BC76xx state */
	u16	TimeCounter;								/* timer counter value */
}BLE_OPERATE;

void BLE_EnterPowerUp(void);
void BLE_EnterPowerSave(void);
void BLE_TimerProcess(void);
void BLE_process(void);

#endif // _BLEPROCESS_H_
